#include "hardware.h"
#include "types.h"
#include "symbol.h"

extern "C" __version_1 void lcd_PUTCH(char D);
extern "C" __version_1 void lcd_PUTCM(BYTE D);
extern "C" __version_1 BYTE lcd_GET(void);
extern "C" __version_1 void lcd_INI(void);

#define WAIT while(lcd_GET() & 0x80);


void Command(BYTE C)
{
  WAIT;
  lcd_PUTCM(C);
}

void Symbol(BYTE Addr, BYTE N, BYTE __flash (*Sym)[8])
{
WAIT;
Command(0x40|(Addr<<3));
for(BYTE i=0; i<N; i++) 
  for(BYTE j=0; j<8; j++)
    {
    WAIT;
    lcd_PUTCH(Sym[i][j]);
    }
}

void InitDisplay(void)
{
lcd_INI();
WAIT;
lcd_PUTCM(0x28); // 4 bits databus
WAIT;
lcd_PUTCM(0x0C); // switch on
WAIT;
lcd_PUTCM(0x01); // clear
WAIT;
lcd_PUTCM(0x0C); // switch on
}

void Write(char __flash * S)
{
if(S) while(*S) 
  {
  WAIT;
  lcd_PUTCH(*S++);
  }
}

void Write(char * S)
{
if(S) while(*S) 
  {
  WAIT;
  lcd_PUTCH(*S++);
  }
}

void Put(BYTE D)
{
  WAIT;
  lcd_PUTCH(D);
}

void PutBCD(BYTE D)
{
  WAIT;
  lcd_PUTCH('0'+((D>>4)&0x0F));
  WAIT;
  lcd_PUTCH('0'+(D&0x0F));
}

void PutScale(int V)
{
  char S[7];
  for(BYTE i=0; i<7; i++) S[i]=3;
  if(V<0) S[0]=6; 
  else if(V>20) S[6]=7; 
  else S[V/3]=V%3;
  for(BYTE i=0; i<7; i++) Put(S[i]);
}
