#ifndef _MAIN_CTR
#define _MAIN_CTR

#include <iom8.h>

/* Crystal oscillator */
#define XTAL      16000000L

/* Nets */

/* Port B */
#define iICP    0
#define oOC1A   1
#define iS4     2
#define oRS     3
#define oRW     4
#define iSCK    5

/* Port C */
#define bD0     0
#define bD1     1
#define bD2     2
#define bD3     3
#define CH_VOLT 6
#define CH_TEMP 7

/* Port D */
#define oE      0
#define oPO     1
#define iINT0   2
#define iINT1   3
#define iS1     4
#define iT1     5
#define iS2     6
#define iS3     7

/* LCD */
#define LCDP_E	PORTD
#define LCDP_RS PORTB
#define LCDP_RW PORTB
#define LCDP_DB PORTC
#define LCDD    DDRC
#define LCDI_DB PINC
#define LCDI_E	oE
#define LCDI_RS oRS
#define LCDI_RW oRW

/* Flags */

#define F_Tick       0x01
#define F_Kbd        0x02  
#define F_Timer      0x04 
#define F_Update     0x08
#define F_Period     0x10
#define F_Null       0x20 

#define SETFLAG(F) Flags |= F
#define CLRFLAG(F) Flags &= ~(F)
#define TGLFLAG(F) Flags ^= F            

/* Key codes */
/* add key flag */
#define K_ADD (1<<iS1)
/* subtract key flag */
#define K_SUB (1<<iS2) 
/* mode key flag */
#define K_MOD (1<<iS3)
/* select key flag */
#define K_SEL (1<<iS4)
/* release flag */
#define K_RLS 0x01
/* long press flag */
#define K_LPR 0x02

#define GETKEYCODE (((PINB & 0x04)|(PIND & 0xD0)) ^ 0xD4)

#define POWER_ON  PORTD &= ~(1<<oPO)
#define POWER_OFF PORTD |= (1<<oPO)
#define POWER_S   (!(PORTD & (1<<oPO)))

#endif
