#include <inavr.h>
#include "hardware.h"
#include "types.h"
#include "tacho.h"
#include "voltm.h"
#include "srvtst.h"
#include "timer.h"
#include "display.h"
#include "utils.h"  
#include "sys.h"

static char S[10];

static void P_Timer(BYTE K)
{
switch(K)
  {
  case 0: 
    POWER_OFF;
    InitTimer(); 
    CLS;
    break; 
  case 1:
    CLRFLAG(F_Timer);
    break;                 
  case K_MOD: CUR(7,0); Put('*'); break;
  case K_MOD|K_RLS: CUR(7,0); Put(' '); break;
  case K_MOD|K_LPR: CUR(7,0); Put('#'); break;
  case K_ADD:
    Flags ^= F_Timer;
    break;           
  case K_SUB:
    CLRFLAG(F_Timer);
    ClearTimer();
    DisplayTime();
    break;
  case 0xFF:
    if(Flags & F_Tick)
      {
      CLRFLAG(F_Tick);
      if(Flags & F_Timer) UpdateTime();
      DisplayTime();
      }
    break;
  }
}

__flash char rpm[]="RPM";
__flash char bl[]="BL=";

static void P_Tacho(BYTE K)
{
switch(K)
  {
  case 0: 
    POWER_OFF;
    InitRPM(); 
    CLS;
    break;
  case 1:
    DoneRPM();
    break;        
  case K_ADD:  
    if(BladeCnt<9) BladeCnt++;
    break;
  case K_SUB:
    if(BladeCnt>1) BladeCnt--;
    break;
  case 0xFF: 
    if(Flags & F_Update)
      {
      CLRFLAG(F_Update);
      CUR(0,0); BinAscS(RPM,5,S); Write(S); Write(rpm);
      CUR(4,1); Write(bl); Put('0'+BladeCnt);
      }
    break;
  }
}

__flash char PS1[]={168,95,95,95,95,168,95,95,0};
__flash char PS2[]="P       ";
__flash char PS3[]={95,95,95,95,95,95,95,95,0};
__flash char ms[]="ms";
__flash char us[]="\004s ";
__flash char pw[]="W=";
       
static void D_Pulse(void)
{
if(!(Flags & F_Period))
  {
  CUR(0,0);
  Write(pw); BinAscS(PPM_pulse_width(),4,S); Write(S); Write(us);
  CUR(0,1);
  PutScale(10+((int)PPM_pulse_width()-1500)/50); Put(' ');
  }
else
  {
  if(PPM_period!=0xFFFF)
    {
    CUR(0,0);
    Put('P'); 
    BinAscS(PPM_period/1000,2,S); Write(S); Put('.');
    BinAsc0((PPM_period%1000)/10,2,S); Write(S); Write(ms);
    CUR(0,1);
    Write(PS1);
    }
  else
    {
    CUR(0,0);
    Write(PS2);
    CUR(0,1);
    Write(PS3);
    }
  }
}

static void P_Pulse(BYTE K)
{
switch(K)
  {
  case 0: 
    Symbol(0,8,Sym0);
    InitICP();
    CLRFLAG(F_Period);
    CLS;
    break;
  case 1:
    DoneICP(); POWER_OFF;
    break;  
  case K_ADD:  
    Flags ^= F_Period;
    break;                   
  case K_MOD:
    if(POWER_S)
      POWER_OFF;
    else
      POWER_ON;
    break; 
  case 0xFF:
    if(Flags & F_Update)
      {
      CLRFLAG(F_Update);
      D_Pulse();
      }
    break;
  }
}

static void P_Volt(BYTE K)
{  
switch(K)
  {
  case 0:
    POWER_OFF;
    CLS;
    break;  
  case 1:
    break; 
  case 0xFF:
    if(Flags & F_Tick)
      {
      CLRFLAG(F_Tick);
      WORD V = Volt();
      CUR(0,0); 
      BinAscS(V/100,3,S); Write(S); Put('.'); BinAsc0(V%100,2,S); Write(S); Put('V');
      }
    break; 
  }
}

__flash char degree[]="\005C";

static void P_Termo(BYTE K)
{
switch(K)
  {
  case 0:
    POWER_OFF;
    CLS;
    break;  
  case 1:
    break; 
  case 0xFF:
    if(Flags & F_Tick)
      {
      CLRFLAG(F_Tick);
      int V = Temp();
      CUR(0,0);
      if(V < 0) {Put('-'); V=-V;} else if(V > 0) Put('+'); else Put(' ');
      BinAscS(V/10,3,S); Write(S); Put('.'); BinAsc0(V%10,1,S); Write(S);
      Write(degree);
      }
    break;
  }
}

__flash char srv[]="S=";
__flash char reg[]="R=";

static void D_Servo(void)
{
CUR(1,0); PutScale(10+((int)PulseWidth()-1500)/50);
CUR(0,1); Write(srv); BinAscS(PulseWidth(),4,S); Write(S); Write(us);
}

static void P_Servo(BYTE K)
{
switch(K)
  {
  case 0: 
    Symbol(0,8,Sym0);
    InitSrvTest();
    CLS;
    D_Servo();
    SETFLAG(F_Null);
    break;
  case 1:
    DoneSrvTest(); POWER_OFF;
    break;                  
  case K_ADD:
    if(PulseWidth()<2100) SetPulse(PulseWidth()+10);
    CLRFLAG(F_Null);
    D_Servo();
    break;
  case K_SUB:
    if(PulseWidth()>900) SetPulse(PulseWidth()-10);
    CLRFLAG(F_Null);
    D_Servo();
    break;
  case K_MOD:
    SetPulse(1500);
    D_Servo();
    if(Flags & F_Null)
      {
      if(POWER_S)
        POWER_OFF;
      else
        if(Volt() < 100) POWER_ON;
      }
    SETFLAG(F_Null);
    break;
  }
}

static void D_Regul(void)
{
CUR(1,0); PutScale((int)(PulseWidth()-1000)/50);
CUR(0,1); Write(reg); BinAscS(PulseWidth(),4,S); Write(S); Write(us);
}

static void P_Regul(BYTE K)
{
switch(K)
  {
  case 0: 
    Symbol(0,8,Sym0);
    InitSrvTest();
    CLS;
    SetPulse(1000);
    SETFLAG(F_Null);
    D_Regul();
    break;
  case 1:
    DoneSrvTest(); POWER_OFF;
    break;                  
  case K_ADD:
    if(PulseWidth()<2100) SetPulse(PulseWidth()+50);
    CLRFLAG(F_Null);
    D_Regul();
    break;
  case K_SUB:
    if(PulseWidth()>900) SetPulse(PulseWidth()-50);
    CLRFLAG(F_Null);
    D_Regul();
    break;
  case K_MOD:
    SetPulse(1000);
    D_Regul();
    if(Flags & F_Null)
      {
      if(POWER_S)
        POWER_OFF;
      else
        POWER_ON;
      }
    SETFLAG(F_Null);
    break;  
  }
}

__flash void (*Fun[7])(BYTE) = {P_Timer,P_Tacho,P_Pulse,P_Volt,P_Termo,P_Servo,P_Regul};
__flash char *ModeTtl[7] = {"TMR","RPM","PPM","VLT","TMP","SRV","REG"};

static BYTE Mode = 0;

__C_task void main(void)
{
PORTD = (1<<oPO);
DDRD  = (1<<oE)|(1<<oPO);
PORTB = (1<<oRW);
DDRB  = (1<<oRS)|(1<<oRW);

InitSystem();
InitADC();
InitDisplay();

if(PINB & (1<<PB5)) Calibr();

__enable_interrupt();

(Fun[0])(0);

for(;;)
  {  
  if(Flags & F_Kbd)
    {
    CLRFLAG(F_Kbd);
    if(GetKey()==K_SEL)
      {
      (Fun[Mode])(1); // out of current mode
      Mode++; if(Mode > 6) Mode = 0;
      (Fun[Mode])(0); // in to selected mode
      }
    else
      (Fun[Mode])(GetKey()); // process another keys
    }
  (Fun[Mode])(0xFF); // idle
  } //loop
} //end of main
