#include "hardware.h"
#include "types.h"
#include "display.h"



__monitor void InitSrvTest(void)
{
// Set output
DDRB |= 1<<oOC1A;
// Setup Timer1: fast PWM, 50Hz, out->OC1A
ICR1 = 39999;
OCR1A = 3000; // 1.5ms
TCCR1A = (1<<COM1A1)|(0<<COM1A0)|(1<<WGM11)|(0<<WGM10);
TCCR1B = (1<<WGM13)|(1<<WGM12)|(0<<CS12)|(1<<CS11)|(0<<CS10);
}

__monitor void DoneSrvTest(void)
{
DDRB &= ~(1<<oOC1A);
TCCR1A = 0;
TCCR1B = 0;
}

__monitor void SetPulse(WORD P)
{
OCR1A = P << 1;
}

__monitor WORD PulseWidth(void)
{
return OCR1A >> 1;
}
