#include "hardware.h"
#include "types.h"
#include "utils.h"
#include "display.h"
#include "sys.h"

typedef struct {
  BYTE s,S,M,H;
  } TIME;

static volatile TIME T = {0,0,0,0};
//static TIME TA[8];

__flash char sTime[] = "Time ";

void DisplayTime(void)
{
  CUR(0,0);
  Write(sTime); if(T.H) PutBCD(T.H);
  CUR(0,1);
  PutBCD(T.M); Put(':'); PutBCD(T.S); Put('.'); Put(T.s+'0');
}

__monitor void InitTimer(void)
{
}

__monitor void DoneTimer(void)
{
}

__monitor void ClearTimer(void)
{
  T.s=0; T.S=0; T.M=0; T.H=0;
}

void UpdateTime(void)
{ // 10 Hz
  T.s++;
  if(T.s > 9)
    {
    T.s = 0;
    T.S = BCDinc(T.S);
    if(T.S == 0x60)
      {
      T.S = 0;
      T.M = BCDinc(T.M);
      if(T.M == 0x60)
        {
        T.M = 0;
        BCDinc(T.H);
        }
      }
    }
}
