#include <inavr.h>
#include "hardware.h"
#include "types.h"
#include "display.h"
#include "sys.h"

#define R1    20.5
#define R2    4.17 

__eeprom float EKv = (R1+R2)/R2;

static float Kv;

__monitor void InitADC(void)
{
ADCSR = (1<<ADEN)|(1<<ADPS2)|(1<<ADPS1)|(1<<ADPS0);
Kv = EKv;
}

static WORD Meas(BYTE N)
{
ADMUX = N;
ADCSR |= (1<<ADSC);
while(!(ADCSR & (1<<ADIF)));
ADCSR &= ~(1<<ADSC);
return ADC;
}

WORD Volt(void)
{
return Meas(6)*Kv*500.0/1024; // 1/100V
}

int Temp(void)
{
return (Meas(7)*5.0/1024-1.375)*10/0.0225; // 1/10
}

void Calibr(void)
{
Kv = 1024.0/Meas(6);
EKv = Kv;
}
