{{
MonitorRCReceiver.spin

    Monitors multiple output PWM channels from an R/C receiver and saves the
    pulse widths in long vars provided to the "start" routine.
    
    Tested with a Spektrum AR6100 receiver, although this should work with other
    r/c receivers.

    The AR6100 sends the aileron channel pulse first, followed by the pitch 
    channel pulse, followed by the elevator channel pulse.   There is about .08ms
    in between, which gives us time to reassign the timer module to each
    successive pin, measuring the time the pulse is high with timer A.

    It is not required that the pulses be in this order, but a latency of one
    pulse interval might be seen if they are not. 

    Tested with 3 channels from ar6100 receiver, where power and ground pins are
    provided +5v and GND, respectively, and the signal pin from each channel goes
    through a 4.7k resistor to an input pin on the Propeller.  Pins are assigned in
    the CON section of this object.

    Resulting pulse width values are in clock cycles. With clock speed set to 80mHz,
    pulse width values will generally range from 80,000 to 160,000  with center around
    120,000.
    
    Use this object in your code as follows:
    --------------------------------------------------------------
    OBJ
      rm    : "MonitorRCReceiver"

    VAR
      long pw1, pw2, pw3     

    PUB Demo  
      rm.start(@pw1, @pw2, @pw3)

      repeat
        ' Code that uses the pulse widths to do something useful
        
     --------------------------------------------------------------
      
}}

CON
  rx_aileron_pin  = 18  
  rx_elevator_pin = 17
  rx_aux_pin      = 16
  rx_rudder_pin   = 15

OBJ
 servoman       :  "ServoManager"               'PWM output manager for servos
  
VAR
  LONG  monStack1[16]   
  LONG  monitorCog1,monitorCog2
  LONG  rx_elevator_addr, rx_aileron_addr, rx_aux_addr
  LONG  rx_aux_active_addr
  LONG  elevatorStartCount, aileronStartCount, auxStartCount
  LONG  elevatorEndCount, aileronEndCount, auxEndCount
  LONG  elevatorPinState, aileronPinState, auxPinState
    
PUB start(eAddr, aAddr, auxAddr, auxActiveAddr) : okay

  rx_elevator_addr := eAddr     ' Save addresses
  rx_aileron_addr  := aAddr
  rx_aux_addr      := auxAddr
  rx_aux_active_addr  := auxActiveAddr

   ' Aux and Rudder need their own cog in case they are not connected
   '  because waitpeq will wait forever if no pulses come in and no
   '  other RX data will get through
    
   monitorCog1 := cognew(MonitorAileronElevatorChannels, @monStack1)   ' Launch cog

   okay :=  monitorCog1
       
PUB stop

  if monitorCog1
    cogstop(monitorCog1~ )  
  if monitorCog2
    cogstop(monitorCog2~ )
 
  
PRI MonitorAileronElevatorChannels | synCnt   
  'set up counter modules and I/O pin configurations from within the new cog 

  ctra[30..26] := %01000                                ' POS detector 
  frqa := 1
  phsa~                                                 ' Clear counts

  ' Set up I/O pin directions and states.
  
  dira[rx_aileron_pin]~                              ' Make pin an input
  dira[rx_elevator_pin]~                             ' Make pin an input 
  dira[rx_aux_pin]~

  '---------------------------------------------------------------------------------
  ' The user may or may not have aux (collective) or rudder connected to the RX
  ' This checks to see if a pin is active before trying to read
  '  pulses from it. Requires pulldown resistors to make sure signal pin is
  '  low during the test.  Sets the flag to let the main program know if these
  '  channels are active.

  long[rx_aux_active_addr] := FALSE
  
  synCnt := clkfreq/4 + cnt
  repeat until synCnt =< cnt     ' wait 1/4 second to check if pins are hooked up to a signal
    if ina[rx_aux_pin] == 1
      long[rx_aux_active_addr] := TRUE
 
  '----------------------------------------------------------------------------------
       
  repeat
     
    ctra[5..0] := rx_aileron_pin 
    waitpeq(|<rx_aileron_pin, |<rx_aileron_pin, 0)   ' Wait for pin to go high.                                           ' Clear to initialize
    waitpeq(0, |<rx_aileron_pin,0)                   ' Wait for pin to go low.
    if(phsa > servoman#SERVO_MIN)                    ' If valid pulse width,
      long[rx_aileron_addr] := phsa                 ' Save width then clear.
    phsa~
    
     if(long[rx_aux_active_addr])  
       ctra[5..0] := rx_aux_pin                       
       waitpeq(|<rx_aux_pin, |<rx_aux_pin, 0)                                           
       waitpeq(0, |<rx_aux_pin,0)                     
       if(phsa > servoman#SERVO_MIN)
         long[rx_aux_addr] := phsa                         
      phsa~
         
    ctra[5..0] := rx_elevator_pin                     ' Same for elevator channel
    waitpeq(|<rx_elevator_pin, |<rx_elevator_pin, 0)                                               
    waitpeq(0, |<rx_elevator_pin,0)                     
    if(phsa > servoman#SERVO_MIN)
        long[rx_elevator_addr] := phsa                      
    phsa~



                                             
    