//#include <avr/io.h>

#include "i2cmaster.h"

#define SSD1502	0x68
//#define SSD1502	0x6A
//#define SSD1502	0x6C
//#define SSD1502	0x6E

#define SMCStereoCtl	0x41

#define SMCStereoF		0x20
#define SMCStereoL		0x30
#define SMCMedianFilter	0x08
#define SMCFlip2F		0x04
#define SMCDeinterlace	0x02

#define SMCStereoMode		0x22
#define SMCMonoMode			0x0a

uint8_t	mode = 0;	//0 - mono; 1 - stereo

void _stop(unsigned int ms)
{
	while (ms)
	{
		unsigned int x;
		for (x = 55; x > 0; x--)
		{
			__asm ("nop");
		}
		ms--;
	}		
}

int main(void)
{
	unsigned char r = 0;
	unsigned char v = 34;
	
	// initialize I2C library
	i2c_init();
	USART_init();

	USART_sendc("hi!\r\n");
	
	//bit 0 is button
	//bits 1 - 2 sync multiplexer
	DDRB = 0x02;
	PORTB = 0x01;	//pull up on button 
					

	while (1)
	{
		if (!(PINB & 0x01))
		{
			if (mode)
			{
				v = SMCMonoMode;
				if (i2c_write_data(SSD1502, 0x41, &v, 1))
				{
					//select sync source for second display (EN)
					DDRB = 0x02;

					USART_sendc("monoscopic mode request sended\r\n");
				}
				else
					USART_sendc("mode change failed!\r\n");
			}
			else
			{
				v = SMCStereoMode;
				if (i2c_write_data(SSD1502, 0x41, &v, 1))
				{
					//select sync source for second display (EN2)
					DDRB = 0x04;	//bit 0 is button

					USART_sendc("stereoscopic mode request sended\r\n");
				}
				else
					USART_sendc("mode change failed!\r\n");
			}
			mode = !mode;
			
			_stop(500);
		}
		_stop(50);
	}

}
