#include <avr/io.h>
#include <avr/interrupt.h>

#include "usart.h"

#ifndef F_CPU
#define F_CPU 1000000UL
#endif


#define USART_BAUDRATE 2400
#define BAUD_PRESCALE (((F_CPU / (USART_BAUDRATE * 16UL))) - 1)

FIFO sb;
FIFO rb;

int USART_init()
{
	UBRR0H = (BAUD_PRESCALE >> 8); // Load upper 8-bits of the baud rate value into the high byte of the UBRR register
	UBRR0L = BAUD_PRESCALE; // Load lower 8-bits of the baud rate value into the low byte of the UBRR register

	UCSR0B = (1 << RXEN0) | (1 << TXEN0);   // Turn on the transmission and reception circuitry
	UCSR0B |= (1 << RXCIE0); // Enable the USART Complete interrupts

	UCSR0C = (1 << UCSZ00) | (1 << UCSZ01); // Use 8-bit character sizes

	sb.used = 0;
	rb.used = 0;
	
	sei(); // Enable the Global Interrupt Enable flag so that interrupts can be processed
}



void USART_send_do()
{
	UDR0 = sb.buff[sb.pos];
}

ISR(USART_TX_vect)
{
	sb.pos ++;
	sb.pos = sb.pos % sizeof(sb.buff);
	sb.used --;
	if (sb.used)
	{
		USART_send_do();
 	}
	else
	{
		UCSR0B &= ~(1 << TXCIE0);
	}
}

unsigned char USART_send(unsigned char d)
{
	if (sb.used < sizeof(sb.buff))
	{
		sb.buff[(sb.pos + sb.used) % sizeof(sb.buff)] = d;
		sb.used ++;
		if (sb.used == 1)
		{
			UCSR0B |= (1 << TXCIE0); // ena
			USART_send_do();
		}

		return 0;
	}
	return 1;
}

ISR(USART_RX_vect)
{
	char ReceivedByte;
	ReceivedByte = UDR0; // Fetch the received byte value into the variable "ByteReceived"

	USART_send(ReceivedByte);
//	extern uint8_t rb_;
//	rb_ = ReceivedByte;
}

unsigned char USART_sendc(const unsigned char *c)
{
	const unsigned char *b = c;
	while (*c)
	{
		if (USART_send(*c))
			return 0;
		c++;
	}
	return c - b;
}

unsigned char USART_send_num(unsigned char c)
{
	char rv = 1;
	char c2 = c / 100;
	char c1 = c % 100 / 10;
	c = c % 10;
	if (c2)
	{
		if (USART_send(c2 + '0'))
			return 0;
		rv ++;
	}
	if (c1 || (rv > 1))
	{
		if (USART_send(c1 + '0'))
			return 0;
		rv ++;
	}
	if (USART_send(c + '0'))
		return 0;
	return rv;
}
